#include "Weather\Init\Common.c"
#include "Weather\Init\Day.c"
#include "Weather\Init\Evening.c"
#include "Weather\Init\Morning.c"
#include "Weather\Init\Night.c"
#include "Weather\Init\DayStorm.c"
#include "Weather\Init\Special.c"
#include "Weather\Init\Rain.c" //navy

int InitWeather()
{
	int n = 0;

	n = Whr_InitNight(n);
	n = Whr_InitMorning(n);
	n = Whr_InitDay(n);
	n = Whr_InitEvening(n);
	n = Whr_InitDayStorm(n);
	n = Whr_InitSpecial(n);
	n = Whr_InitRain(n);

	Whr_InitCommon();

	Trace("Init weathers complete. " + n + " weathers found.");

	for (int i=0; i<n; i++)
	{
		if (!CheckAttribute(&Weathers[i], "Stars.Enable")) { Weathers[i].Stars.Enable = false; }
		if (!CheckAttribute(&Weathers[i], "Planets.Enable")) { Weathers[i].Planets.Enable = false; }
		if (!CheckAttribute(&Weathers[i], "Sun.Reflection.Enable")) { Weathers[i].Sun.Reflection.Enable = false; }
		if (!CheckAttribute(&Weathers[i], "Sounds.Sea.Postfix")) { Weathers[i].Sounds.Sea.Postfix = ""; }
		if (!CheckAttribute(&Weathers[i], "Sun.Moon")) { Weathers[i].Sun.Moon = false; }

		if (!CheckAttribute(&Weathers[i], "Rain.DropsNearNum")) { Weathers[i].Rain.DropsNearNum = 0; }
		if (!CheckAttribute(&Weathers[i], "Rain.DropsFarNum")) { Weathers[i].Rain.DropsFarNum = 0; }
		if (!CheckAttribute(&Weathers[i], "Rain.DropsNearRadius")) { Weathers[i].Rain.DropsNearRadius = 12.0; }
		if (!CheckAttribute(&Weathers[i], "Rain.DropsFarRadius")) { Weathers[i].Rain.DropsFarRadius = 55.0; }
		if (!CheckAttribute(&Weathers[i], "Rain.DropsLifeTime")) { Weathers[i].Rain.DropsLifeTime = 0.25; }
		if (!CheckAttribute(&Weathers[i], "Rain.DropsSize")) { Weathers[i].Rain.DropsSize = 0.07; }
		if (!CheckAttribute(&Weathers[i], "Rain.DropsTexture")) { Weathers[i].Rain.DropsTexture = "weather\rain_drops.tga.tx"; }
		if (!CheckAttribute(&Weathers[i], "Rain.DropsColor")) { Weathers[i].Rain.DropsColor = argb(63, 255, 255, 255); }

		//#20171220-01 Foam enable
		if (!CheckAttribute(&Weathers[i], "Sea2.FoamEnable")) { Weathers[i].Sea2.FoamEnable = true; }
		if (!CheckAttribute(&Weathers[i], "Sea2.FoamK")) { Weathers[i].Sea2.FoamK = 0.1; }
		if (!CheckAttribute(&Weathers[i], "Sea2.FoamV")) { Weathers[i].Sea2.FoamV = 5.0; }
		if (!CheckAttribute(&Weathers[i], "Sea2.FoamUV")) { Weathers[i].Sea2.FoamUV = 0.05; }
		if (!CheckAttribute(&Weathers[i], "Sea2.FoamTexDisturb")) { Weathers[i].Sea2.FoamTexDisturb = 0.7; }

		if (!CheckAttribute(&Weathers[i], "Fog.Enable")) { Weathers[i].Fog.Enable = false; }
		if (!CheckAttribute(&Weathers[i], "Fog.Height")) { Weathers[i].Fog.Height = 150; }
		if (!CheckAttribute(&Weathers[i], "Fog.Start")) { Weathers[i].Fog.Start = 10; }
		if (!CheckAttribute(&Weathers[i], "Fog.Density")) { Weathers[i].Fog.Density = 0.0003; }
		if (!CheckAttribute(&Weathers[i], "Fog.IslandDensity")) { Weathers[i].Fog.IslandDensity = 0.0003; }
		if (!CheckAttribute(&Weathers[i], "Fog.SeaDensity")) { Weathers[i].Fog.SeaDensity = 0.0003; }
		if (!CheckAttribute(&Weathers[i], "Fog.Color")) { Weathers[i].Fog.Color = argb(0,10,10,10); }

		if (!CheckAttribute(&Weathers[i], "SpecialSeaFog.Enable")) { Weathers[i].SpecialSeaFog.Enable = false; }
		if (!CheckAttribute(&Weathers[i], "SpecialSeaFog.Height")) { Weathers[i].SpecialSeaFog.Height = 150; }
		if (!CheckAttribute(&Weathers[i], "SpecialSeaFog.Start")) { Weathers[i].SpecialSeaFog.Start = 10; }
		if (!CheckAttribute(&Weathers[i], "SpecialSeaFog.Density")) { Weathers[i].SpecialSeaFog.Density = 0.0003; }
		if (!CheckAttribute(&Weathers[i], "SpecialSeaFog.IslandDensity")) { Weathers[i].SpecialSeaFog.IslandDensity = 0.0003; }
		if (!CheckAttribute(&Weathers[i], "SpecialSeaFog.SeaDensity")) { Weathers[i].SpecialSeaFog.SeaDensity = 0.0003; }
		if (!CheckAttribute(&Weathers[i], "SpecialSeaFog.Color")) { Weathers[i].SpecialSeaFog.Color = argb(0,10,10,10); }
	}

	return n;
}
